<?php

/* -----------------------------------------------------------------
 * 	$Id: leguide.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class LeGuide {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function LeGuide() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'selling';
        $this->v_module_name = 'LeGuide.net';
        $this->v_module_homepage = 'www.leguide.net';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'leguide.csv';
        $this->v_filename = 'leguide.php';
        $this->v_keyname = 'LEGUIDE';
        $this->v_linkname = 'leguide';
        $this->v_delimiter = '|';
        $this->v_enclosure = '';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, ',', '');
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, ',', '');
        $p_products_array['products_description'] = trim(no_html($p_products_array['products_description']));
        $p_products_array['products_short_description'] = trim(no_html($p_products_array['products_short_description']));
        $p_products_array['products_availability'] = 0;
        if ($p_products_array['products_availability'] != '0000-00-00 00:00:00') {
            $date = $p_products_array['products_availability'];
            $time = mktime(0, 0, 0, substr($date, 5, 2), substr($date, 8, 2), substr($date, 0, 4));
            $p_products_array['products_availability'] = date("d", $time - time());
            if ($time_diff <= 0)
                $p_products_array['products_availability'] = 0;
        }
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_categories'] = 'kategorie';
        $t_csv_fields_array['products_id'] = 'produdt_id';
        $t_csv_fields_array['products_name'] = 'name';
        $t_csv_fields_array['products_price'] = 'preis';
        $t_csv_fields_array['products_link'] = 'product_url';
        $t_csv_fields_array['products_image_1'] = 'bild_url';
        $t_csv_fields_array['products_description'] = 'beschreibung';
        $t_csv_fields_array['products_shipping_costs'] = 'lieferkosten';
        $t_csv_fields_array['products_availability'] = 'verfuegbarkeit';
        $t_csv_fields_array['manufacturers_name'] = 'marke';
        $t_csv_fields_array['products_ean'] = 'ean';
        $t_csv_fields_array['products_stock'] = 'garantie';
        $t_csv_fields_array['products_model'] = 'produktreferenz';
        $t_csv_fields_array['products_old_price'] = 'alter_preis';
        $t_csv_fields_array['products_currency'] = 'waehrung';
        $t_csv_fields_array['products_discount_type'] = 'gebrauchtwaren';
        $t_csv_fields_array['products_shippingtime'] = 'lieferzeit';
        return($t_csv_fields_array);
    }

}

?>